# iOS SDK


## 集成步骤

1. Manual import: Drag 'HYTTS. framework' into the project. Then go to Gnera ->Framewoks, Under Libraries and Embedded Content, change the 'Embed' in HYTTS. framework to 'Embed&Sign'.

2. Ensure that the pod has introduced SocketRocket 0.6.0 AFNetworking, SSZipArchive 2.4.3。

###  Add application related permissions
1. Add 'Privacy - Microphone Usage Description' to the 'info. plist' file of the project to add microphone access permissions.


### Calling steps/example code

#### Get instance

- Get an instance of TTS

```
    TTSParams *params = [[TTSParams alloc] init];
    params.langType = @"";
    [[TTSManger shareInstance] setSdkParams:params]
    [[TTSManger shareInstance] initWithWithAppid:@"" WithAppSecret:@"" WithinitBlock:^(NSError * _Nonnull Error) {
        
        if (Error == nil) {
            NSLog(@"Initialization successful");
        }
        
    }];
   
```

#### Authorization activation

（1）Configure authorization parameters
|Name|Type|Description|Default Value|
|-------|-------|-------|-------|
|online|string|true，false |true|



```
    TTSParams *parames = [[TTSManger getTTSManger] getSdkParams];
    params.online = @"true";

```


#### Parameter settings
|parameter|Type|Is it necessary|Description|Default Value|
|-------|-------|-------|-------|-------|
|text|String|true|Text to be synthesized|REQUIRED|
|lang_type|String|true|Language type|REQUIRED|
|voice|String|false|voice|none|
|format|String|false|Audio encoding format|pcm|
|sample_rate|Integer|false|audio sample rate|24000|
|volume|Integer|false|[0.1, 3], default is 1, usually only one decimal place is needed|1|
|speech_rate|Float|false|[0.2,3], default is 1, usually only one decimal place is needed|1.0|
|pitch_rate|Float|false|[0.1, 3], default is 1, usually only one decimal place is needed
|0|
|emotion|String|false|affective style|none|
|silence_duration|Integer|false|End of sentence silence duration|none|
```

TTSParams *params = [[TTSParams alloc] init]; params.text = @"";
params.langType = @"";
params.format = @"pcm";
params.voice = @"xiaohui";
params.volume = 50;
params.speech_rate = 1;
params.pitch_rate = 0;
params.sample_rate = 16000;
[[TTSManger shareInstance] setSdkParams:params];

```
#### Start/Stop Synthesis

```
TTSParams *parames = [[TTSManger getTTSManger] getSdkParams];
parames.text = @"";
[[TTSManger getTTSManger] onStart];//Start synthesis
[[TTSManger getTTSManger] onStop]; //Stop synthesis
```

## Status code table

| error code | message             | Solution                                           |
| ------ | -------------------- | -------------------------------------------------- |
| 110002 | Unauthorized ability          | Change the parameter to an authorized capability or contact the business to add AI capability           |
| 110003 | App ID expired            | Contact the business department to increase the validity period of the app ID                         |
| 110004 | Call out of limit           | Contact business to increase authorization frequency             |
| 110005 | Concurrent over limit            | Contact Business to add concurrency           |
| 300000 | parameter error             | Check parameters (parameters passed are not specified, incorrect, or empty strings) |
| 300001 | Missing parameter            | Missing required parameters    |
| 300004 | The synthesized text is empty | Missing synthetic text     |
| 300005 | The length of the synthesized text exceeds the limit     | Text for synthesized speech, with a length limit of 1024 bytes                   |
| 300100 | Synthesis in progress, please try again later | After the synthesis is completed, proceed with the operation   |
| 300101 | Playing, please try again later | After playing, proceed with the operation      |
